<?php
/**
 * Plugin Name:           AutomatorWP - wpForo
 * Plugin URI:            https://automatorwp.com/add-ons/wpforo/
 * Description:           Connect AutomatorWP with wpForo.
 * Version:               1.0.4
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-wpforo
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.1
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\wpForo
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_wpForo {

    /**
     * @var         AutomatorWP_wpForo $instance The one true AutomatorWP_wpForo
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_wpForo self::$instance The one true AutomatorWP_wpForo
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_wpForo();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_WPFORO_VER', '1.0.4' );

        // Plugin file
        define( 'AUTOMATORWP_WPFORO_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_WPFORO_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_WPFORO_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/create-reply.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/create-topic.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/like-post.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/dislike-post.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/get-like.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/get-dislike.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/vote-post.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/get-vote.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/answer-question.php';
            require_once AUTOMATORWP_WPFORO_DIR . 'includes/triggers/get-answer.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'wpforo', array(
            'label' => 'wpForo',
            'icon'  => AUTOMATORWP_WPFORO_URL . 'assets/wpforo.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'wpforo\\wpforo' ) ) { // > 2.0.0
            if ( ! class_exists ( 'wpForo' ) ) { // < 2.0.0
                return false;
            }
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_wpForo instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_wpForo The one true AutomatorWP_wpForo
 */
function AutomatorWP_wpForo() {
    return AutomatorWP_wpForo::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_wpForo' );
